import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.*;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import objectos_casa.*;
import java.io.*;
import java.util.ArrayList;

import org.python.indexer.Def;
import org.python.util.PythonInterpreter;

/**
 * Created by Pedro on 06/04/2016.
 */
public class Prototipo extends Application {
    Boolean debug;
    Casa casaAberta;
    int coordx_ultimo_objecto_clicado, coordy_ultimo_objecto_clicado;

    //variaveis das componentes da interface grafica
    BorderPane janelaPrototipo;
    MenuBar menuProtipo;
    ContextMenu menuBDRato;
    Menu menuCasa,menuCodigo;
    MenuItem novoItem, abrirItem, guardarItem, editarObjecto, apagarObjecto, executarCodigo, gerarCodigo;
    ScrollPane painelInventario, painelObjectos,painelCasa;
    GridPane grelhaCasa;
    VBox inventario;
    HBox listaObjectos;

    //cria uma nova casa vazia
    public void novaCasa(){
        casaAberta= new Casa();
    }


    public void novaCasa(String nome, String tipo_ret, int x, int y){
        casaAberta=new Casa(nome,tipo_ret,x,y);
    }

    //abre uma casa dada uma casa já existente
    public void abrirCasa(Casa c){
        casaAberta=c;
    }

    //abre a casa guardada no nome do ficheiro dado
    public void abrirCasa(String nomeFicheiro) throws IOException {


        FileInputStream abrir_ficheiro= new FileInputStream(nomeFicheiro);
        ObjectInputStream read=new ObjectInputStream(abrir_ficheiro);

        //se ja tiver uma casa aberta
        if(casaAberta!=null) {
            guardarCasa();
        }
        try {
            casaAberta=(Casa)read.readObject();


            if(!debug){
                grelhaCasa.getChildren().clear();

                ImageView icone;

                for(int a=0;a<casaAberta.tamanho_x;a++){
                    int y=0;
                    for(int b=casaAberta.tamanho_y-1;b>=0;b--) {

                        Button botao=new Button();
                        icone=new ImageView("/objectos_casa/imagens/"+casaAberta.casa[a][b].getIconeNome());

                        icone.setFitHeight(98);
                        icone.setFitWidth(98);
                        botao.setMaxSize(100,100);
                        botao.setMinSize(100,100);
                        botao.setGraphic(icone);
                        botao.setContextMenu(menuBDRato);
                        botao.setOnMousePressed(e -> {
                            if(e.isSecondaryButtonDown()) {
                                //debug
                                //System.out.println("Coord x: "+GridPane.getColumnIndex(botao)+
                                //      "   Coord y: "+Math.abs(casaAberta.tamanho_y-1-GridPane.getRowIndex(botao)));
                                coordy_ultimo_objecto_clicado=Math.abs(casaAberta.tamanho_y-1-GridPane.getRowIndex(botao));
                                coordx_ultimo_objecto_clicado=GridPane.getColumnIndex(botao);
                            }
                        });
                        grelhaCasa.add(botao, a, y);
                        y++;
                    }
            }
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    //guarda a casa actualmente aberta
    public void guardarCasa() throws IOException{

        //se tiver uma casa actualmente aberta no jogo
        if(casaAberta!=null) {
            FileOutputStream ficheiro = new FileOutputStream(casaAberta.nome_casa + ".casa");
            ObjectOutputStream escreve = new ObjectOutputStream(ficheiro);

            escreve.writeObject(casaAberta);

            escreve.close();
        }
        else
            System.err.println("É necessário abrir ou criar uma nova casa para poder-se guardar uma casa!");
        
    }

    //devolve o codigo da casa guardada no ficheiro
    public String getCodigoCasa(String nomeFicheiro) throws IOException{
        String codigo="";
        Casa temp;
        LeitorCasa ler=new LeitorCasa();
        FileInputStream abrir_ficheiro= new FileInputStream(nomeFicheiro);
        ObjectInputStream read=new ObjectInputStream(abrir_ficheiro);

        try {
            temp=(Casa)read.readObject();
            codigo=ler.ler_casa(temp,false);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        
        return codigo;
    }

    //devolve o codigo da casa com ou sem os prints das coordenadas injectadas
    public String getCodigoCasaAberta(Boolean com_coords){

        LeitorCasa ler=new LeitorCasa();
        String codigo=ler.ler_casa(casaAberta,com_coords);

        return codigo;
    }

    //executa o codigo e devolve a String com o resultado obtido e, conforme o boolean, as coordenadas da execucao
    // do codigo
    public String executarCasa(String[]valores, Boolean animada) throws IOException{
        //gerar codigo da casa actualmente aberta
        String codigo_py = getCodigoCasaAberta(animada);
        String codigo_funcs="";
        String resultado="";

        //gerar codigo de chamadas de funcoes disponiveis
        for(Function_call f: casaAberta.funcoesDisponiveis) {
            //se existir a funcao da casa actualmente aberta ignora-se a geracao do codigo
            if(f.nome.equals(casaAberta.nome_casa))
                continue;
            codigo_funcs += getCodigoCasa(f.nome + ".casa") + "\n";
        }
        //verifica se existe uma funcao definida para utilizar os valores dados
        if(casaAberta.casa[0][0].tipo_objecto().equals("def_func")){
            if(valores.length==((Def_func)casaAberta.casa[0][0]).parametros.size()) {

                //gera o codigo da casa e prepara-se para adicionar os valores existentes no array
                codigo_py = "import sys\n\n" + codigo_funcs + codigo_py + '\n' + "print(\'Resultado:\'+str(" +
                        casaAberta.nome_casa + "(";

                //se houver 1 ou mais valores de passagem
                if(valores.length>0)
                    //adiciona o primeiro valor a funcao da casa
                    codigo_py+=valores[0];

                //percorre todos os valores do array ignorando o primeiro que ja foi (ou nao) adicionado
                for (int i = 1; i < valores.length; i++)
                    codigo_py += ","+valores[i];

                //termina o resto do codigo
                codigo_py+=")))";

            }
            //caso o numero de valores dados nao correspondem ao numero de parametros da funcao da casa
            else
                System.err.println("O número de valores a utilizar nos parâmetros da função "+casaAberta.nome_casa+
                        " não coincide!");
        }
        //caso nao existir uma funcao da casa definida e for dado um array de valores vazio
        else if(valores.length==0){
            codigo_py = "import sys\n\n" + codigo_py;
        }
        //no caso de ter sido dado um array com valores mas a casa nao tiver a sua funcao definida
        else{
            System.err.println("Não está definida nenhuma função!");
            return resultado;
        }


        //debugging: print do codigo python a ser executado
        //System.out.println("Codigo executado: "+codigo_py+"\n\n");

        //preparar o interpretador de codigo python
        PythonInterpreter py=new PythonInterpreter();

        //fazer as preparacoes para conseguir-se ler os prints feitos pelo interpretador
        ByteArrayOutputStream buffer_leitor = new ByteArrayOutputStream();
        PrintStream leitor=new PrintStream(buffer_leitor);
        py.setOut(leitor);

        //executar a string do codigo python que ira fazer prints na consola
        //System.out.println("Código executado:\n"+codigo_py);
        py.exec(codigo_py);

        //fecha-se o printstream para evitar a leitura de mais prints
        leitor.close();

        //le-se o buffer dos prints feitos durante a execucao do codigo python
        resultado=buffer_leitor.toString();
        buffer_leitor.reset();


        //debugging: imprime a string captada no buffer
        //System.out.println("Output: \n"+resultado);

        //caso queira-se a string com a animacao da execucao do codigo
        if(animada)
            //devolve toda a string lida no buffer
            return resultado;
        //caso contrario devolve apenas a string do valor
        else{
            return resultado.replace("Resultado:","").trim();
        }

    }

    //devolve o boolean a indicar se a casa passou todos os testes dados
    public Boolean testarCasa(ArrayList<String> resultados_esperados, ArrayList<String[]> valores) throws IOException{
        Boolean passou_teste=true;

        //certifica que ambas as listas têm as mesmas dimensoes
        if(resultados_esperados.size()==valores.size()) {

            //percorre as duas listas
            for (int i = 0; i < resultados_esperados.size(); i++) {

                //debugging: print dos valors utilizados no teste da casa
                //System.out.println("Array valores: "+ Arrays.toString(valores.get(i))+ "\nValor esperado: "
                //        +resultados_esperados.get(i));

                //debugging: print do valor devolvido apos feita a execucao
                //System.out.println("\nValor devolvido: "+executarCasa(valores.get(i),false));

                //executa o código e compara o resultado obtido com o esperado
                if(!executarCasa(valores.get(i),false).equals(resultados_esperados.get(i)))
                    passou_teste=false;

                //debugging: print dos booleans em cada teste
                //System.out.println("Teste "+i+": "+passou_teste);
            }
            return passou_teste;
        }
        else {
            System.err.println("As listas com os valores de teste têm tamanhos diferentes!");
            return false;
        }
    }


    //start que inicializa a janela da interface do jogo
    @Override
    public void start(Stage primaryStage){
        primaryStage.setTitle("Protótipo Jogo");

        debug=false;

        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(new File (System.getProperty("user.dir")) );
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Ficheiros CASA","*.casa"));

        janelaPrototipo = new BorderPane();
        janelaPrototipo.setMinSize(800,500);


        editarObjecto = new MenuItem("Editar");
        editarObjecto.setOnAction( e-> {
            abrirEditorObjecto(casaAberta.casa[coordx_ultimo_objecto_clicado][coordy_ultimo_objecto_clicado]);
        });
        apagarObjecto = new MenuItem("Apagar");
        /*apagarObjecto.setOnAction( e-> {

        });*/
        menuBDRato = new ContextMenu(editarObjecto,apagarObjecto);

        painelCasa = new ScrollPane();
        painelCasa.setPrefSize(679,367);
        janelaPrototipo.setCenter(painelCasa);
        janelaPrototipo.setAlignment(painelCasa,Pos.CENTER);

            grelhaCasa = new GridPane();
            grelhaCasa.setPrefSize(644,348);
            grelhaCasa.setGridLinesVisible(true);

        painelCasa.setContent(grelhaCasa);

        menuCasa = new Menu("Casa");
        menuCasa.setMnemonicParsing(false);

            novoItem = new MenuItem("Nova");
            novoItem.setMnemonicParsing(false);


            abrirItem = new MenuItem("Abrir");
            abrirItem.setMnemonicParsing(false);

            abrirItem.setOnAction(
                    (event) -> {
                        File ficheiro = fileChooser.showOpenDialog(primaryStage);
                        if(ficheiro!=null) {
                            try {
                                abrirCasa(ficheiro.getPath());
                                guardarItem.setDisable(false);
                                gerarCodigo.setDisable(false);
                                executarCodigo.setDisable(false);
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
            );


            guardarItem = new MenuItem("Guardar");
            guardarItem.setMnemonicParsing(false);

            guardarItem.setOnAction(
                (event) -> {
                    try {
                        guardarCasa();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            );

            guardarItem.setDisable(true);


        menuCasa.getItems().addAll(novoItem, abrirItem, guardarItem);


        executarCodigo = new MenuItem("Executar");
        executarCodigo.setMnemonicParsing(false);
        executarCodigo.setDisable(true);

        gerarCodigo = new MenuItem("Gerar");
        gerarCodigo.setMnemonicParsing(false);
        gerarCodigo.setOnAction(e->{
            if(casaAberta!=null){
                mostrarCodigoCasa(getCodigoCasaAberta(false));
            }
        });
        gerarCodigo.setDisable(true);

        menuCodigo = new Menu("Código");
        menuCodigo.setMnemonicParsing(false);

        menuCodigo.getItems().addAll(executarCodigo, gerarCodigo);


        menuProtipo = new MenuBar(menuCasa,menuCodigo);
        janelaPrototipo.setTop(menuProtipo);
        janelaPrototipo.setAlignment(menuProtipo,Pos.CENTER);


        painelObjectos = new ScrollPane();
        painelObjectos.setPrefSize(800,125);
        janelaPrototipo.setBottom(painelObjectos);
        janelaPrototipo.setAlignment(painelObjectos,Pos.CENTER);

            listaObjectos = new HBox();
            listaObjectos.setPrefSize(797,123);


        painelObjectos.setContent(listaObjectos);


        painelInventario = new ScrollPane();
        painelInventario.setPrefSize(153,375);
        janelaPrototipo.setRight(painelInventario);
        janelaPrototipo.setAlignment(painelInventario,Pos.CENTER);

            inventario = new VBox();
            inventario.setPrefSize(151,348);

        painelInventario.setContent(inventario);


        primaryStage.setScene(new Scene(janelaPrototipo));
        primaryStage.show();

    }

    //funcao que abre uma janela com o codigo Python gerado da casa aberta
    public void mostrarCodigoCasa(String codigo){
        Stage codigoStage = new Stage();
        codigoStage.setTitle("Codigo gerado");


        TextArea textoCodigo= new TextArea();
        textoCodigo.setPrefSize(398,398);
        textoCodigo.setEditable(false);
        textoCodigo.setText(codigo);

        ScrollPane scrollCodigo = new ScrollPane(textoCodigo);
        scrollCodigo.setPrefSize(400,400);

        Pane janela = new Pane(scrollCodigo);
        janela.setPrefSize(400,400);

        Scene sceneGerar = new Scene(janela,400,400);
        codigoStage.setScene(sceneGerar);
        codigoStage.show();

    }

    //funcao que abre o editor de um objecto
    public void abrirEditorObjecto(ObjectoCasa obj){

        Stage editorStage = new Stage();
        editorStage.setTitle("Editar objecto...");

        VBox vbox = new VBox();
        vbox.setPrefSize(407,347);

        ScrollPane dados = new ScrollPane(vbox);
        dados.setPrefSize(409,349);

        Button botaoGuardar = new Button("Guardar");
        botaoGuardar.setLayoutX(61);
        botaoGuardar.setLayoutY(361);
        botaoGuardar.setMnemonicParsing(false);

        Button botaoCancelar = new Button("Cancelar");
        botaoCancelar.setLayoutX(270);
        botaoCancelar.setLayoutY(361);
        botaoCancelar.setMnemonicParsing(false);
        botaoCancelar.setOnAction(e->{
            editorStage.close();
        });

        Pane painel=new Pane(dados, botaoGuardar, botaoCancelar);
        painel.setPrefSize(410,400);
        painel.setMinSize(410,400);

        Scene editorScene = new Scene(painel,410,400);

        if(obj.tipo_objecto().equals("null")) {
            mostraMensagemErro("Objecto não editável!");
            return;
        }

        //Caracteristicas da interface de cada item do objecto:
        /*Label label = new Label("Texto");
        label.setPrefSize(101,31);

        TextField valor = new TextField("Dado");
        valor.setPrefSize(300,33);

        HBox hbox = new HBox(label,valor);
        hbox.setPrefSize(407,30);

        vbox.getChildren().add(hbox);
        */


        switch(obj.tipo_objecto()){

            case "int":

                Label label_int1 = new Label("Nome");
                label_int1.setPrefSize(101,31);

                TextField valor_int1 = new TextField(((Int_casa)obj).nome);
                valor_int1.setPrefSize(300,33);

                HBox hbox_int1 = new HBox(label_int1,valor_int1);
                hbox_int1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_int1);

                Label label_int2 = new Label("Valor");
                label_int2.setPrefSize(101,31);

                TextField valor_int2 = new TextField(((Int_casa)obj).valor+"");
                valor_int2.setPrefSize(300,33);

                HBox hbox_int2 = new HBox(label_int2,valor_int2);
                hbox_int2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_int2);
                break;

            case "char":

                Label label_char1 = new Label("Nome");
                label_char1.setPrefSize(101,31);

                TextField valor_char1 = new TextField(((Char_casa)obj).nome);
                valor_char1.setPrefSize(300,33);

                HBox hbox_char1 = new HBox(label_char1,valor_char1);
                hbox_char1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_char1);

                Label label_char2 = new Label("Valor");
                label_char2.setPrefSize(101,31);

                TextField valor_char2 = new TextField(((Char_casa)obj).valor+"");
                valor_char2.setPrefSize(300,33);

                HBox hbox_char2 = new HBox(label_char2,valor_char2);
                hbox_char2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_char2);

            break;


            case "double":

                Label label_double1 = new Label("Nome");
                label_double1.setPrefSize(101,31);

                TextField valor_double1 = new TextField(((Double_casa)obj).nome);
                valor_double1.setPrefSize(300,33);

                HBox hbox_double1 = new HBox(label_double1,valor_double1);
                hbox_double1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_double1);

                Label label_double2 = new Label("Valor");
                label_double2.setPrefSize(101,31);

                TextField valor_double2 = new TextField(((Double_casa)obj).valor+"");
                valor_double2.setPrefSize(300,33);

                HBox hbox_double2 = new HBox(label_double2,valor_double2);
                hbox_double2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_double2);

            break;

            case "boolean":

                Label label_boolean1 = new Label("Nome");
                label_boolean1.setPrefSize(101,31);

                TextField valor_boolean1 = new TextField(((Boolean_casa)obj).nome);
                valor_boolean1.setPrefSize(300,33);

                HBox hbox_boolean1 = new HBox(label_boolean1,valor_boolean1);
                hbox_boolean1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_boolean1);

                Label label_boolean2 = new Label("Valor");
                label_boolean2.setPrefSize(101,31);

                TextField valor_boolean2 = new TextField(((Boolean_casa)obj).valor+"");
                valor_boolean2.setPrefSize(300,33);

                HBox hbox_boolean2 = new HBox(label_boolean2,valor_boolean2);
                hbox_boolean2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_boolean2);

            break;

            case "string":

                Label label_string1 = new Label("Nome");
                label_string1.setPrefSize(101,31);

                TextField valor_string1 = new TextField(((String_casa)obj).nome);
                valor_string1.setPrefSize(300,33);

                HBox hbox_string1 = new HBox(label_string1,valor_string1);
                hbox_string1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_string1);

                Label label_string2 = new Label("Valor");
                label_string2.setPrefSize(101,31);

                TextField valor_string2 = new TextField(((String_casa)obj).valor+"");
                valor_string2.setPrefSize(300,33);

                HBox hbox_string2 = new HBox(label_string2,valor_string2);
                hbox_string2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_string2);

            break;

            case "array_double":

                Label label_array_double1 = new Label("Nome");
                label_array_double1.setPrefSize(101,31);

                TextField valor_array_double1 = new TextField(((Array_double)obj).nome);
                valor_array_double1.setPrefSize(300,33);

                HBox hbox_array_double1 = new HBox(label_array_double1,valor_array_double1);
                hbox_array_double1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_array_double1);

                //FALTA DEFINIR EDITOR DA LISTA

                break;

            case "array_int":

                Label label_array_int1 = new Label("Nome");
                label_array_int1.setPrefSize(101,31);

                TextField valor_array_int1 = new TextField(((Array_int)obj).nome);
                valor_array_int1.setPrefSize(300,33);

                HBox hbox_array_int1 = new HBox(label_array_int1,valor_array_int1);
                hbox_array_int1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_array_int1);

                //FALTA DEFINIR EDITOR DA LISTA

                break;

            case "array_string":

                Label label_array_string1 = new Label("Nome");
                label_array_string1.setPrefSize(101,31);

                TextField valor_array_string1 = new TextField(((Array_string)obj).nome);
                valor_array_string1.setPrefSize(300,33);

                HBox hbox_array_string1 = new HBox(label_array_string1,valor_array_string1);
                hbox_array_string1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_array_string1);

                //FALTA DEFINIR EDITOR DA LISTA

                break;

            case "begin_for_ciclo":

                //FALTA DEFINIR EDITOR DO ITERADOR

                Label label_for1 = new Label("Valor inicial");
                label_for1.setPrefSize(101,31);

                TextField inicial_for1 = new TextField(((Begin_for_ciclo)obj).valor_inicial+"");
                inicial_for1.setPrefSize(300,33);

                HBox hbox_for1 = new HBox(label_for1,inicial_for1);
                hbox_for1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_for1);

                Label label_for2 = new Label("Valor final");
                label_for2.setPrefSize(101,31);

                TextField final_for2 = new TextField(((Begin_for_ciclo)obj).valor_final+"");
                final_for2.setPrefSize(300,33);

                HBox hbox_for2 = new HBox(label_for2,final_for2);
                hbox_for2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_for2);

                Label label_for3 = new Label("Operação aplicada");
                label_for3.setPrefSize(101,31);

                TextField final_for3 = new TextField(((Begin_for_ciclo)obj).op_iterador+"");
                final_for3.setPrefSize(300,33);

                HBox hbox_for3 = new HBox(label_for2,final_for2);
                hbox_for3.setPrefSize(407,30);

                vbox.getChildren().add(hbox_for3);

                break;

            case "begin_while_ciclo":

                Label label_while1 = new Label("Condição");
                label_while1.setPrefSize(101,31);

                TextField valor_while1 = new TextField(((Begin_while_ciclo)obj).condicao);
                valor_while1.setPrefSize(300,33);

                HBox hbox_while1 = new HBox(label_while1,valor_while1);
                hbox_while1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_while1);

                break;

            case "begin_if":

                Label label_if1 = new Label("Condição");
                label_if1.setPrefSize(101,31);

                TextField valor_if1 = new TextField(((Begin_if)obj).expressao);
                valor_if1.setPrefSize(300,33);

                HBox hbox_if1 = new HBox(label_if1,valor_if1);
                hbox_if1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_if1);

                break;

            case "switch_case":

                Label label_switch1 = new Label("Condição");
                label_switch1.setPrefSize(101,31);

                TextField valor_switch1 = new TextField(((Switch_case)obj).expressao);
                valor_switch1.setPrefSize(300,33);

                HBox hbox_switch1 = new HBox(label_switch1,valor_switch1);
                hbox_switch1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_switch1);

                break;

            case "def_func":

                Label label_func1 = new Label("Nome");
                label_func1.setPrefSize(101,31);

                TextField valor_func1 = new TextField(((Def_func)obj).nome);
                valor_func1.setPrefSize(300,33);

                HBox hbox_func1 = new HBox(label_func1,valor_func1);
                hbox_func1.setPrefSize(407,30);

                //FALTA DEFINIR EDITOR DOS PARAMETROS

                vbox.getChildren().add(hbox_func1);

                break;

            case "return":

                Label label_return1 = new Label("Valor");
                label_return1.setPrefSize(101,31);

                TextField valor_return1 = new TextField(((Return_casa)obj).expressao_valor_retorno);
                valor_return1.setPrefSize(300,33);

                HBox hbox_return1 = new HBox(label_return1,valor_return1);
                hbox_return1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_return1);

                break;

            case "maquina_boolean":

                Label label_maquina_bool1 = new Label("Nome variavel");
                label_maquina_bool1.setPrefSize(101,31);

                TextField valor_maquina_bool1 = new TextField(((Maquina_boolean)obj).variavel);
                valor_maquina_bool1.setPrefSize(300,33);

                HBox hbox_maquina_bool1 = new HBox(label_maquina_bool1,valor_maquina_bool1);
                hbox_maquina_bool1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_bool1);

                Label label_maquina_bool2 = new Label("Expressão");
                label_maquina_bool2.setPrefSize(101,31);

                TextField valor_maquina_bool2 = new TextField(((Maquina_boolean)obj).expressao+"");
                valor_maquina_bool2.setPrefSize(300,33);

                HBox hbox_maquina_bool2 = new HBox(label_maquina_bool2,valor_maquina_bool2);
                hbox_maquina_bool2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_bool2);


                break;

            case "maquina_char":

                Label label_maquina_char1 = new Label("Nome variavel");
                label_maquina_char1.setPrefSize(101,31);

                TextField valor_maquina_char1 = new TextField(((Maquina_char)obj).variavel);
                valor_maquina_char1.setPrefSize(300,33);

                HBox hbox_maquina_char1 = new HBox(label_maquina_char1,valor_maquina_char1);
                hbox_maquina_char1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_char1);

                Label label_maquina_char2 = new Label("Expressão");
                label_maquina_char2.setPrefSize(101,31);

                TextField valor_maquina_char2 = new TextField(((Maquina_char)obj).expressao+"");
                valor_maquina_char2.setPrefSize(300,33);

                HBox hbox_maquina_char2 = new HBox(label_maquina_char2,valor_maquina_char2);
                hbox_maquina_char2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_char2);

                break;

            case "maquina_double":

                Label label_maquina_double1 = new Label("Nome variavel");
                label_maquina_double1.setPrefSize(101,31);

                TextField valor_maquina_double1 = new TextField(((Maquina_double)obj).variavel);
                valor_maquina_double1.setPrefSize(300,33);

                HBox hbox_maquina_double1 = new HBox(label_maquina_double1,valor_maquina_double1);
                hbox_maquina_double1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_double1);

                Label label_maquina_double2 = new Label("Expressão");
                label_maquina_double2.setPrefSize(101,31);

                TextField valor_maquina_double2 = new TextField(((Maquina_double)obj).expressao+"");
                valor_maquina_double2.setPrefSize(300,33);

                HBox hbox_maquina_double2 = new HBox(label_maquina_double2,valor_maquina_double2);
                hbox_maquina_double2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_double2);

                break;

            case "maquina_int":

                Label label_maquina_int1 = new Label("Nome variavel");
                label_maquina_int1.setPrefSize(101,31);

                TextField valor_maquina_int1 = new TextField(((Maquina_int)obj).variavel);
                valor_maquina_int1.setPrefSize(300,33);

                HBox hbox_maquina_int1 = new HBox(label_maquina_int1,valor_maquina_int1);
                hbox_maquina_int1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_int1);

                Label label_maquina_int2 = new Label("Expressão");
                label_maquina_int2.setPrefSize(101,31);

                TextField valor_maquina_int2 = new TextField(((Maquina_int)obj).expressao+"");
                valor_maquina_int2.setPrefSize(300,33);

                HBox hbox_maquina_int2 = new HBox(label_maquina_int2,valor_maquina_int2);
                hbox_maquina_int2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_int2);

                break;

            case "maquina_string":

                Label label_maquina_string1 = new Label("Nome variavel");
                label_maquina_string1.setPrefSize(101,31);

                TextField valor_maquina_string1 = new TextField(((Maquina_string)obj).variavel);
                valor_maquina_string1.setPrefSize(300,33);

                HBox hbox_maquina_string1 = new HBox(label_maquina_string1,valor_maquina_string1);
                hbox_maquina_string1.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_string1);

                Label label_maquina_string2 = new Label("Expressão");
                label_maquina_string2.setPrefSize(101,31);

                TextField valor_maquina_string2 = new TextField(((Maquina_string)obj).expressao+"");
                valor_maquina_string2.setPrefSize(300,33);

                HBox hbox_maquina_string2 = new HBox(label_maquina_string2,valor_maquina_string2);
                hbox_maquina_string2.setPrefSize(407,30);

                vbox.getChildren().add(hbox_maquina_string2);

                break;

            default:
                mostraMensagemErro("Objecto não editável!");
                return;
        }

        editorStage.setScene(editorScene);

        editorStage.show();

    }


    //funcao que mostra a janela de erro
    public void mostraMensagemErro(String msg){
        Stage s = new Stage();

        TextArea mensagem= new TextArea("Erro: " + msg);
        mensagem.setPrefSize(270,142);
        mensagem.setEditable(false);

        Button confirmar=new Button("OK");
        confirmar.setOnAction(e->{
            s.close();
        });
        confirmar.setMnemonicParsing(false);
        confirmar.setAlignment(Pos.CENTER);
        confirmar.setLayoutX(119);
        confirmar.setLayoutY(151);

        Pane janela = new Pane(mensagem,confirmar);
        janela.setPrefSize(271,187);

        Scene sc = new Scene(janela);
        s.setTitle("Erro!");
        s.setScene(sc);
        s.show();
    }


    //devolve o boolean a indicar se a string dada contem apenas digitos numericos
    public Boolean apenasNumeros(String frase){
        for(int i=0;i<frase.length();i++) {
            if(!Character.isDigit(frase.charAt(i)))
                return false;
        }

        return true;
    }

    //main do prototipo para testes
    //argumentos opcionais:
    //debug_testes - para testar manualmente as funcoes do prototipo
    //interface_texto - para executar o prototipo com a interface de texto/linha de comandos
    public static void main(String[] args) throws IOException{


        if(args.length==0) {
            launch();

        }

        else if(args[0].equals("debug_testes")){

            Prototipo jogo = new Prototipo();

            jogo.debug=true;

            //jogo.abrirCasa("pow.casa");

            jogo.novaCasa("pow","int",40,10);

        //testes de erro
            //Casa casa=new Casa("casaTeste",-1,10);
            //Casa casa=new Casa("casaTeste",40,-1);
            //Casa casa=new Casa("",40,10);
            //Casa casa=new Casa(null,40,10);


            ArrayList <ObjectoCasa> argumentos=new ArrayList(0);
            argumentos.add(new Int_casa("x",jogo.casaAberta.ultimo_id+1));
            argumentos.add(new Int_casa("n", jogo.casaAberta.ultimo_id+2));
            Def_func funcao=new Def_func(1,"pow",argumentos);
            jogo.casaAberta.ultimo_id+=2;

            jogo.casaAberta.casa[0][0]=funcao;

        //testes de erro
            //jogo.casaAberta.colocarObjecto(0,1,funcao);
            //jogo.casaAberta.colocarObjecto(1,0,funcao);
            //jogo.casaAberta.colocarObjecto(0,10,funcao);
            //jogo.casaAberta.colocarObjecto(40,0,funcao);

        //versao IF da casa funcao pow
            /*
            jogo.casaAberta.casa[1][0]=new Begin_if(jogo.casaAberta.ultimo_id+1,"n<0");
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[2][1]=new Return_casa(jogo.casaAberta.ultimo_id+1,"-1");
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[3][0]=new End_if(jogo.casaAberta.ultimo_id+1,1);
            jogo.casaAberta.ultimo_id++;
            */
        //FIM IF

        //versao SWITCH da casa funcao pow

            jogo.casaAberta.casa[1][0]=new Begin_switch(jogo.casaAberta.ultimo_id+1);
            jogo.casaAberta.ultimo_id++;

            jogo.casaAberta.casa[1][1]=new Switch_case(jogo.casaAberta.ultimo_id,"n==0",false);
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[2][1]=new Return_casa(jogo.casaAberta.ultimo_id+1,"1");
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[3][1]=new End_switch(jogo.casaAberta.ultimo_id+1,1);
            jogo.casaAberta.ultimo_id++;

            jogo.casaAberta.casa[1][2]=new Switch_case(jogo.casaAberta.ultimo_id,"n<0 or x<0",false);
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[2][2]=new Return_casa(jogo.casaAberta.ultimo_id+1,"-1");
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[3][2]=new End_switch(jogo.casaAberta.ultimo_id+1,1);
            jogo.casaAberta.ultimo_id++;

            jogo.casaAberta.casa[1][3]=new Switch_case(jogo.casaAberta.ultimo_id,"x==0",true);
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[2][3]=new Return_casa(jogo.casaAberta.ultimo_id+1,"0");
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[3][3]=new End_switch(jogo.casaAberta.ultimo_id+1,1);
            jogo.casaAberta.ultimo_id++;

            jogo.casaAberta.casa[3][0]=new End_switch(jogo.casaAberta.ultimo_id+1,0);
            jogo.casaAberta.ultimo_id++;

        //FIM SWITCH

            Int_casa int_test=new Int_casa("resultado",jogo.casaAberta.ultimo_id+1);
            int_test.setValor(1);
            jogo.casaAberta.casa[5][0]= int_test;
            jogo.casaAberta.ultimo_id++;


            jogo.casaAberta.casa[7][0]=new Begin_while_ciclo(jogo.casaAberta.ultimo_id+1,"n>0");
            jogo.casaAberta.ultimo_id++;
            jogo.casaAberta.casa[10][0]=new End_ciclo(jogo.casaAberta.ultimo_id+1,1);
            jogo.casaAberta.ultimo_id++;


            jogo.casaAberta.casa[8][0]=new Maquina_int("resultado","resultado*x",jogo.casaAberta.ultimo_id+1);
            jogo.casaAberta.ultimo_id++;


            jogo.casaAberta.casa[9][0]=new Maquina_int("n","n-1",jogo.casaAberta.ultimo_id+1);
            jogo.casaAberta.ultimo_id++;

            jogo.casaAberta.casa[11][0]=new Return_casa(jogo.casaAberta.ultimo_id+1,"resultado");


        //testar guardar e abrir casa

            jogo.guardarCasa();

            jogo.abrirCasa("pow.casa");


        //gera codigo sem os prints das coordenadas injectadas neste
            String codigo_py=jogo.getCodigoCasaAberta(false);

        //gera codigo com os prints das coordenadas injectadas neste
            //String codigo_py=jogo.getCodigoCasaAberta(true);

        //prints do codigo gerado, das regras e da casa
            System.out.println(codigo_py);
            jogo.casaAberta.printCasa();
            System.out.print("\n\n");
            jogo.casaAberta.printRegrasCasa();
            System.out.print("\n\n");
            jogo.casaAberta.printListaVariaveisCasa();
            System.out.print("\n\n");


        //valores a utilizar no teste da casa
            ArrayList<String> val_esperados=new ArrayList<>();
            val_esperados.add("0");
            val_esperados.add("1");
            val_esperados.add("2");
            val_esperados.add("8");
            val_esperados.add("-1");
            ArrayList<String[]>val_utilizados=new ArrayList<>();
            val_utilizados.add(new String[]{"0","0"});
            val_utilizados.add(new String[]{"10","0"});
            val_utilizados.add(new String[]{"2","1"});
            val_utilizados.add(new String[]{"2","3"});
            val_utilizados.add(new String[]{"-1","-1"});

        //print do resultado dos testes
            System.out.println("Valor final dos teste: "+jogo.testarCasa(val_esperados,val_utilizados));


        }


        //INTERFACE DE TEXTO========================================================================INICIO

        else if(args[0].equals("interface_texto")){

            String input_linha;
            int x,y;
            BufferedReader buff= new BufferedReader(new InputStreamReader(System.in));

            Prototipo jogo = new Prototipo();
            jogo.debug=true;



            do{//CICLO DO MENU PRINCIPAL PROTOTIPO============================================================INICIO
                File pasta= new File(System.getProperty("user.dir"));
                File [] lista_ficheiros=pasta.listFiles(new FileFilter() {
                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".casa");
                    }
                });
                System.out.println("Escolha uma opção:\n");
                System.out.println("0: Nova casa    1: Abrir ficheiro casa    2: Fechar o protótipo");
                input_linha=buff.readLine();


                //nova casa=============================================================================INICIO

                switch (input_linha){
                    case "0":
                        String nome,tipo_retorno;
                        System.out.println("Escreva o nome da nova casa:");
                        nome=buff.readLine();
                        do {
                            System.out.println("Seleccione o tipo de variável de retorno:");
                            System.out.println("0: void   1: int   2: double   3: string   4: char   5: boolean   \n" +
                                    "6: array_double   7: array_int   8: array_string");
                            input_linha=buff.readLine();
                            switch(input_linha){
                                case "0":
                                    tipo_retorno="void";
                                    break;
                                case "1":
                                    tipo_retorno="int";
                                    break;
                                case "2":
                                    tipo_retorno="double";
                                    break;
                                case "3":
                                    tipo_retorno="string";
                                    break;
                                case "4":
                                    tipo_retorno="char";
                                    break;
                                case "5":
                                    tipo_retorno="boolean";
                                    break;
                                case "6":
                                    tipo_retorno="array_double";
                                    break;
                                case "7":
                                    tipo_retorno="array_int";
                                    break;
                                case "8":
                                    tipo_retorno="array_string";
                                    break;
                                default:
                                    System.err.println("Opção inválida! Tente outra vez.");
                                    continue;
                            }
                            break;//ciclo

                        }while(true);

                        do{
                            System.out.println("Digite o número da dimensão x da casa:");
                            input_linha=buff.readLine();

                            if(jogo.apenasNumeros(input_linha)){
                                x=Integer.parseInt(input_linha);
                                if(x>0)
                                    break;//ciclo
                                else
                                    System.out.println("O número tem de ser maior que 0!");
                            }
                            else
                                System.out.println("Número inválido!");
                        }while(true);

                        do{
                            System.out.println("Digite o número da dimensão y da casa:");
                            input_linha=buff.readLine();

                            if(jogo.apenasNumeros(input_linha)){
                                y=Integer.parseInt(input_linha);
                                if(y>0)
                                    break;
                                else
                                    System.out.println("O número tem de ser maior que 0!");
                            }
                            else
                                System.out.println("Número inválido!");
                        }while(true);

                        jogo.novaCasa(nome,tipo_retorno,x,y);

                        System.out.println("Casa criada!\n");

                        break;//switch

                    //nova casa=============================================================================FIM


                    //abrir casa============================================================================INICIO

                    case "1":
                        System.out.println("Ficheiros casa guardados:");
                        for(File f : lista_ficheiros){
                            System.out.println(f.getName());
                        }
                        do{
                            System.out.println("Escreva o nome do ficheiro que deseja abrir:");
                            input_linha=buff.readLine();
                            try {
                                jogo.abrirCasa(input_linha);

                                System.out.println("Ficheiro aberto com sucesso!");
                                break;//ciclo
                            }
                            catch (IOException e){
                                System.err.println("Ficheiro não encontrado! Tente outra vez.");
                            };
                        }while(true);
                        break;//switch

                    //abrir casa============================================================================FIM


                    case "2"://fechar prototipo
                        System.out.println("Aplicação fechada.");
                        return;


                    default:
                        System.err.println("Opção inválida! Tente outra vez.");
                        continue;
                }

                //interface do editor utilizando as funcoes da casa, este menu aparece apos aberta uma casa ou
                // criada uma nova casa. sai do ciclo ao fechar-se a casa ou o prototipo


                do{//CICLO DA INTERFACE CASA ABERTA=========================================================INICIO

                    System.out.println("Print da casa:\n");
                    jogo.casaAberta.printCasa();

                    System.out.println("\nOpções:");

                    System.out.println(
                            "0: Guardar e fechar casa             1: Fechar casa sem guardar    2: Colocar novo objecto\n"+
                            "3: Alterar objecto                   4: Remover objecto            5: Disponibilizar nova função\n" +
                            "6: Alterar recursividade da casa     7: Mostrar código Python      8: Executar casa\n" +
                            "9: Fechar o protótipo");

                    input_linha=buff.readLine();
                    if(jogo.apenasNumeros(input_linha))
                        switch (input_linha){
                            case "0":
                                jogo.guardarCasa();
                                System.out.println("Casa fechada e guardada.");
                                break;

                            case "1":

                                System.out.println("Casa fechada sem guardar.");
                                break;


                            //MENU COLOCAR OBJECTO==============================================INICIO

                            case "2":

                                do{
                                    System.out.println("Em que posição x?");
                                    input_linha=buff.readLine();

                                    if(jogo.apenasNumeros(input_linha)){
                                        x=Integer.parseInt(input_linha);
                                        break;
                                    }
                                    else
                                        System.out.println("Número inválido! Tente outra vez.");
                                }while(true);

                                do{
                                    System.out.println("Em que posição y?");
                                    input_linha=buff.readLine();

                                    if(jogo.apenasNumeros(input_linha)){
                                        y=Integer.parseInt(input_linha);
                                        break;//ciclo
                                    }
                                    else
                                        System.out.println("Número inválido! Tente outra vez.");
                                }while(true);

                                do {
                                    System.out.println("Seleccione o tipo do objecto a colocar:");
                                    System.out.println(
                                            "0: int              1: double           2: string            3: char\n" +
                                            "4: boolean          5: array_double     6: array_int         7: array_string\n" +
                                            "8: begin_for_ciclo  9: begin_if         10: begin_switch     11: begin_while_ciclo\n" +
                                            "12: def_func        13: switch_case     14: maquina_char     15: maquina_double\n" +
                                            "16: maquina_int     17: maquina_string  18: maquina_boolean  19: return\n" +
                                            "20: continue        21: break           22: Função..."
                                    );
                                    input_linha=buff.readLine();
                                    switch(input_linha){
                                        case "0":
                                            input_linha="int";
                                            break;
                                        case "1":
                                            input_linha="double";
                                            break;
                                        case "2":
                                            input_linha="string";
                                            break;
                                        case "3":
                                            input_linha="char";
                                            break;
                                        case "4":
                                            input_linha="boolean";
                                            break;
                                        case "5":
                                            input_linha="array_double";
                                            break;
                                        case "6":
                                            input_linha="array_int";
                                            break;
                                        case "7":
                                            input_linha="array_string";
                                            break;
                                        case "8":
                                            input_linha="begin_for_ciclo";
                                            break;
                                        case "9":
                                            input_linha="begin_if";
                                            break;
                                        case "10":
                                            input_linha="begin_switch";
                                            break;
                                        case "11":
                                            input_linha="begin_while_ciclo";
                                            break;
                                        case "12":
                                            input_linha="def_func";
                                            break;
                                        case "13":
                                            input_linha="switch_case";
                                            break;
                                        case "14":
                                            input_linha="maquina_char";
                                            break;
                                        case "15":
                                            input_linha="maquina_double";
                                            break;
                                        case "16":
                                            input_linha="maquina_int";
                                            break;
                                        case "17":
                                            input_linha="maquina_string";
                                            break;
                                        case "18":
                                            input_linha="maquina_boolean";
                                            break;
                                        case "19":
                                            input_linha="return";
                                            break;
                                        case "20":
                                            input_linha="continue";
                                            break;
                                        case "21":
                                            input_linha="break";
                                            break;
                                        case "22":
                                            input_linha="funcao";
                                        default:
                                            System.err.println("Opção inválida! Tente outra vez.");
                                            continue;
                                    }
                                    break;//ciclo

                                }while(true);

                                if(input_linha.equals("funcao")) {
                                    System.out.println("Lista de funções disponíveis:");
                                    jogo.casaAberta.printListaFuncoesCasa();
                                    do {
                                        System.out.println("Escreva o número da função a colocar:");
                                        input_linha = buff.readLine();
                                        if(jogo.apenasNumeros(input_linha)) {
                                            int index = Integer.parseInt(input_linha);
                                            if(index>=0 && index<jogo.casaAberta.funcoesDisponiveis.size()) {
                                                jogo.casaAberta.colocarFuncao(x, y, jogo.casaAberta.funcoesDisponiveis.get(index));
                                                break;
                                            }
                                            else
                                                System.out.println("Número inválido! Tente outra vez.");
                                        }
                                        else
                                            System.out.println("Digite apenas números! Tente outra vez.");
                                    }while(true);
                                }
                                else
                                    jogo.casaAberta.colocarNovoObjecto(x,y,input_linha);
                                continue;

                                //MENU COLOCAR OBJECTO==============================================FIM

                            case "3"://alterar objecto

                                do{
                                    System.out.println("Em que posição x?");
                                    input_linha=buff.readLine();

                                    if(jogo.apenasNumeros(input_linha)){
                                        x=Integer.parseInt(input_linha);
                                        break;
                                    }
                                    else
                                        System.out.println("Número inválido! Tente outra vez.");
                                }while(true);

                                do{
                                    System.out.println("Em que posição y?");
                                    input_linha=buff.readLine();

                                    if(jogo.apenasNumeros(input_linha)){
                                        y=Integer.parseInt(input_linha);
                                        break;//ciclo
                                    }
                                    else
                                        System.out.println("Número inválido! Tente outra vez.");
                                }while(true);

                                jogo.casaAberta.modificarObjecto(x,y);

                                continue;

                            case "4"://remover objecto

                                do{
                                    System.out.println("Em que posição x?");
                                    input_linha=buff.readLine();

                                    if(jogo.apenasNumeros(input_linha)){
                                        x=Integer.parseInt(input_linha);
                                        break;
                                    }
                                    else
                                        System.out.println("Número inválido! Tente outra vez.");
                                }while(true);

                                do{
                                    System.out.println("Em que posição y?");
                                    input_linha=buff.readLine();

                                    if(jogo.apenasNumeros(input_linha)){
                                        y=Integer.parseInt(input_linha);
                                        break;//ciclo
                                    }
                                    else
                                        System.out.println("Número inválido! Tente outra vez.");
                                }while(true);

                                jogo.casaAberta.removerObjecto(x,y);

                                continue;

                            case "5"://disponibilizar nova funcao
                                lista_ficheiros=pasta.listFiles(new FileFilter() {
                                    @Override
                                    public boolean accept(File pathname) {
                                        return pathname.getName().endsWith(".casa") &&
                                                !pathname.getName().contains(jogo.casaAberta.nome_casa);
                                    }
                                });

                                System.out.println("Lista de casas a adicionar como nova função:");
                                for(File f: lista_ficheiros)
                                    System.out.println(f.getName());

                                do {
                                    System.out.println("Escreva o nome da casa (sem a extensão .casa) a adicionar:");
                                    System.out.println("(Ou \"cancelar\" para voltar ao menu anterior)");
                                    input_linha=buff.readLine();
                                    Casa temp;
                                    try{//tenta a leitura da casa com o nome introduzido
                                        FileInputStream abrir_ficheiro= new FileInputStream(input_linha);
                                        ObjectInputStream read=new ObjectInputStream(abrir_ficheiro);
                                        temp=(Casa)read.readObject();
                                    }
                                    catch (ClassNotFoundException e) {
                                        System.err.println("Erro a abrir casa! Tente outra vez.");
                                        continue;
                                    };
                                    //adiciona as informacao dessa casa para criar e adicionar a lista de funcoes disponiveis
                                    // na casa
                                    if(temp.casa[0][0].tipo_objecto().equals("def_func")) {
                                        Def_func temp_def=(Def_func)temp.casa[0][0];

                                        Function_call funcao = new Function_call(jogo.casaAberta.ultimo_id + 1,
                                                temp.nome_casa, temp.tipo_valor_retorno);
                                        for (ObjectoCasa o : temp_def.parametros) {
                                            switch (o.tipo_objecto()){
                                                case "boolean":
                                                    funcao.addArg(((Boolean_casa)o).nome,"boolean");
                                                    break;

                                                case "char":
                                                    funcao.addArg(((Char_casa)o).nome,"char");
                                                    break;

                                                case "double":
                                                    funcao.addArg(((Double_casa)o).nome,"double");
                                                    break;

                                                case "int":
                                                    funcao.addArg(((Int_casa)o).nome,"int");
                                                    break;

                                                case "string":
                                                    funcao.addArg(((String_casa)o).nome,"string");
                                                    break;

                                                case "array_string":
                                                    funcao.addArg(((Array_string)o).nome,"array_string");
                                                    break;

                                                case "array_double":
                                                    funcao.addArg(((Array_double)o).nome,"array_double");
                                                    break;

                                                case "array_int":
                                                    funcao.addArg(((Array_int)o).nome,"array_int");
                                                    break;
                                            }
                                        }

                                        jogo.casaAberta.addFuncaoCasa(funcao);
                                        jogo.casaAberta.ultimo_id++;
                                        System.out.println("Função adicionada!");
                                    }
                                    else {
                                        System.out.println("A função desta casa não está definida!");
                                        continue;
                                    }

                                    break;//ciclo

                                }while(true);

                                break;//switch


                            //MENU ALTERAR RECURSIVIDADE============================================INICIO

                            case "6"://alterar recursividade
                                String recursividade="desactivada";
                                if(jogo.casaAberta.permiteRecursividade)
                                    recursividade="activada";

                                System.out.println("A recursividade na está: "+recursividade);
                                System.out.println("Deseja...");
                                if(jogo.casaAberta.permiteRecursividade)
                                    System.out.println("0: Desactivar recursividade  1: Voltar ao menu anterior");
                                else
                                    System.out.println("0: Activar recursividade     1: Voltar ao menu anterior");
                                input_linha=buff.readLine();
                                do {
                                    switch (input_linha) {
                                        case "0":
                                            if(jogo.casaAberta.permiteRecursividade)
                                                for(Function_call f:jogo.casaAberta.funcoesDisponiveis) {
                                                    if (f.nome.equals(jogo.casaAberta.nome_casa)) {
                                                        jogo.casaAberta.funcoesDisponiveis.remove(f);
                                                        jogo.casaAberta.permiteRecursividade=false;
                                                        break;//ciclo for each
                                                    }
                                                }
                                            else
                                                jogo.casaAberta.permitirRecursividade();
                                            break;//switch

                                        case "1":
                                            break;//switch

                                        default:
                                            System.out.println("Número inválido! Tente outra vez.");
                                            continue;
                                    }
                                    break;//ciclo
                                }while(true);

                                continue;

                                //MENU ALTERAR RECURSIVIDADE============================================FIM

                            case "7"://mostrar codigo python
                                System.out.println("Código:\n" + jogo.getCodigoCasaAberta(false)+"\n\n");
                                continue;

                            case "8"://executar casa
                                System.out.println("ATENÇÃO: Só é possível utilizar valores legíveis pelo utilizador.\n" +
                                        "Executar casas que recebam arrays como argumentos não é possível neste tipo de interface.");
                                System.out.println("ATENÇÃO 2: Não é feita verificação dos valores (quanto ao seu tipo) inseridos pelo utilizador.");
                                String[]valores= new String[0];
                                Boolean cancelar=false;

                                if(jogo.casaAberta.casa[0][0].tipo_objecto().equals("def_func")) {
                                    Def_func temp=(Def_func)jogo.casaAberta.casa[0][0];
                                    String nome;
                                    valores = new String[temp.parametros.size()];
                                    for(int i=0;i<temp.parametros.size();i++){
                                        //retirar o nome do argumento
                                        ObjectoCasa o=temp.parametros.get(i);
                                        switch (o.tipo_objecto()){
                                            case "boolean":
                                                nome=((Boolean_casa)o).nome;
                                                break;

                                            case "char":
                                                nome=((Char_casa)o).nome;
                                                break;

                                            case "double":
                                                nome=((Double_casa)o).nome;
                                                break;

                                            case "int":
                                                nome=((Int_casa)o).nome;
                                                break;

                                            case "string":
                                                nome=((String_casa)o).nome;
                                                break;
                                            default:
                                                nome="";
                                        }
                                        if(nome.equals("")){
                                            System.out.println("Argumento inválido ou incompativel neste tipo de interface! Execução cancelada.");
                                            cancelar=true;
                                            break;//ciclo
                                        }
                                        else {
                                            System.out.println("Digite um valor a utilizar no argumento " + nome + " do tipo " + o.tipo_objecto() + ":");
                                            valores[i]=buff.readLine();
                                        }
                                    }
                                    //se ocorrer algume problema no input dos argumentos da casa cancela a execucao e
                                    // volta ao menu anterior
                                    if(cancelar)
                                        continue;
                                }
                                System.out.println("\nResultado:\n"+jogo.executarCasa(valores,false)+"\n");
                                continue;

                            case "9":
                                System.out.println("Aplicação fechada.");
                                return;

                            default:
                                System.err.println("Opção inválida! Tente outra vez.");
                                break;//switch

                        }//fim do switch

                    else {
                        System.out.println("Número inválido! Tente outra vez.");
                        continue;
                    }

                    break;//ciclo

                }while(true);//CICLO DO MENU CASA ABERTA=========================================================FIM



            }while(true);//CICLO DO MENU PRINCIPAL PROTOTIPO============================================================FIM



        }

        //INTERFACE DE TEXTO========================================================================FIM

    }
}

